// priority: 21

ServerEvents.entityLootTables(e => {
    let 分组后的配置 = {};
    多物品规则配置.forEach((规则) => {
        let 实体ID = 规则[0];
        if (!分组后的配置[实体ID]) {
            分组后的配置[实体ID] = { 是否需要覆盖: false, 物品规则: [] };
        }
        if (规则[2] === "覆盖") {
            分组后的配置[实体ID].是否需要覆盖 = true;
        }
        分组后的配置[实体ID].物品规则.push(规则);
    });
    Object.entries(分组后的配置).forEach(([实体ID, 配置]) => {
        e.modify(实体ID, table => {
            if (配置.是否需要覆盖) {
                table.clearPools();
            }
            配置.物品规则.forEach(单行规则 => {
                let [, 物品列表, , 是否需玩家击杀] = 单行规则;
                物品列表.forEach(物品信息 => {
                    let [物品ID, 最小数量, 最大数量] = 物品信息;

                    table.addPool(pool => {
                        pool.rolls = 1;
                        if (是否需玩家击杀) {
                            pool.addCondition({ "condition": "minecraft:killed_by_player" });
                        }
                        let 物品条目 = pool.addItem(物品ID);
                        if (最小数量 === 最大数量) {
                            物品条目.addFunction({ "function": "minecraft:set_count", "count": 最小数量 });
                        } else {
                            物品条目.addFunction({ "function": "minecraft:set_count", "count": { "type": "minecraft:uniform", "min": 最小数量, "max": 最大数量 } });
                        }
                    });
                });
            });
        });
    });
});